function [x_3rd, y_3rd, x_3rd_opp, y_3rd_opp] = third_circle(c_round, rr, ecs)

r1 = c_round(1,3)+rr+ecs;
r2 = c_round(2,3)+rr+ecs;
cc(1,:) = [c_round(1,1),c_round(1,2),0];
cc(2,:) = [c_round(2,1),c_round(2,2),0];

[x,y] = circcirc(c_round(1,1),c_round(1,2),r1,c_round(2,1),c_round(2,2),r2);     % 求两个圆的交点
point1 = [x(1) y(1) 0];    % 第一个交点，二维向量变为三维向量
point2 = [x(2) y(2) 0];    % 第二个交点，二维向量变为三维向量
vector1 = point1-cc(1,:);   
vector2 = cc(2,:)-point1;
direction = cross(vector1,vector2);    %两个向量叉乘，如果是正，三个点就是逆时针

if isnan(x) |  isnan(y)
    x_3rd = 0;
    y_3rd = 0;
    x_3rd_opp = 0;
    y_3rd_opp = 0;
elseif direction>1
    x_3rd = x(1);
    y_3rd = y(1);
    x_3rd_opp = x(2);
    y_3rd_opp = y(2);
else
    x_3rd = x(2);
    y_3rd = y(2);
    x_3rd_opp = x(1);
    y_3rd_opp = y(1);
end


% axis equal;
% viscircles([c_round(1,1),c_round(1,2)],c_round(1,3));
% viscircles([c_round(2,1),c_round(2,2)],c_round(2,3));
% viscircles([c_round(1,1),c_round(1,2)],r1);
% viscircles([c_round(2,1),c_round(2,2)],r2);
% viscircles([x_3rd,y_3rd],rr)

end