%% This is to generate 2D Geometry of white matter
% Unit: um

function [c_fix, edge_out, number, VF, d_mean_real, d_var, trytry] = Perpendicular_function(mode_here, median_here, num, poro, ecs, trytime, sort_fraction, coefficient_d)

% clear;
% close all;
%% 1. Initiation

% poro = 0.3;   % Porosity = 0.3
% ecs = 0.07;   % Extracellular space = 0.38-0.64 nm. will change it to be a random number between 0.38 and 0.64 nm
% trytime = 50;
% num = 201;   % will generente 500 axons
% if num >0 || num <= 100
%     sort_fraction = 0.65;
% elseif num > 100 || num <= 200
%     sort_fraction = 0.9;
% elseif num > 200 || num <= 500
%     sort_fraction = 1;
% elseif num > 500 || num <= 1000
%     sort_fraction = 1;
% else
%     sort_fraction = 1;
% end

volume_fraction_ini = 1-poro;   % volume_fraction is to get the area of rectangular
volume_fraction = 0;  %  live ECM fraction
VF = 0.1;
idx = 1;    % idx for the circles that have been generated
flag = 0;
flag2 = 0;
c_fix = zeros(num,3);   % to store all the circles' information of each picture
Axon_fraction = zeros(1,1);    % to store all the Axon's fraction of each picture
VF1 = [];    % to store volume fractions of every loop
trytry = 0;
number = 0;


%% 2.Generate the porous medium
while number < num-2 
    %|| VF < volume_fraction_ini*0.9 
 % 0.99 is a tolerance. The whole run ends when volume fraction meets the need

        % 2.2 Initialization for each new medium.
        
        change_round = 0;
        change_circle = 0;
        change_r = 0;
        
        %     if number == num-4 && trytry > 50
        %         break;
        %     end
        
        
        if flag == 1
            break;
        end
        
        if flag2 == 1
            continue;
        end
        
        idx = 1;
        
        position = zeros(num,2);   % position
        c = zeros(num,3);    % to store x,y,r of all circles
        %%
        % 2.3 The following lines generate a random vector of radius (r) and then sort
        % the radius by descend. The aim is to find the minimum sort_fraction of the radius
        % and put them at the end of the vector, so that the chance to     pass a loop
        % is higher.
        
        %   d = coefficient_d*(0.7+abs(random('Normal',1.2,1,num,1)))/2;
        

        mu = log(median_here);
        delta = sqrt(mu-log(mode_here));
        mu_real = 1;
        delta_real = 1;
        while abs(mu_real-mu)/mu>0.01 || abs(delta_real-delta)/delta>0.01
            d = round(lognrnd(mu,delta,[1,num]),2);
            mu_real = log(median(d));
            delta_real = sqrt(mu_real-log(mode(d)));
        end
        d_mean = mean(d);
        r_ini = sort(d/2,'descend');
        r_front = r_ini(1:fix(sort_fraction*num));
        r_behind = r_ini(fix(sort_fraction*num)+1:num);
        randIndex = randperm(fix(sort_fraction*num));
        r = [r_front(randIndex);r_behind];
        %     figure(1);
        %     histogram(d);    % disribution of the diameters
        Area_cirlces = sum(r.^2*pi);      % calculate area of all the circles so as to calculate the area of the rectangular
        %%
        % 2.4 Generate the first 3 circles
        
        c_round = zeros(2,3);
        % 1st circle
        c(idx,:) = [position(idx,1), position(idx,2), r(idx)];
        c_round(idx,:) = c(idx,:);
        idx = idx+1;
        
        % 2nd circle
        position(idx,:) = [position(idx,1), position(1,2)+(r(1)+r(idx)+ecs)];
        c(idx,:) = [position(idx,1), position(idx,2), r(idx)];
        c_round(idx,:) = c(idx,:);
        idx = idx+1;
        
        % 3rd circle
        rr3 = r(idx);
        %     figure (2);
        [x_3rd, y_3rd, x_3rd_opp, y_3rd_opp] = third_circle(c_round,rr3,ecs);
        position(idx,:) = [x_3rd_opp, y_3rd_opp];
        c(idx,:) = [position(idx,1), position(idx,2), r(idx)];
        
        %     figure (2);
        %     axis equal;
        %     for idx = 1:3
        %         viscircles([c(idx,1) c(idx,2)],c(idx,3));
        %         NO = num2str(idx);
        %         text(c(idx,1),c(idx,2),NO);
        %     end
        idx = idx+1;
        %%
        % 2.5 Genereate the rectangle
        
        area_circles = sum(pi*r.^2);
        area_rectangular = area_circles./volume_fraction_ini;
        edge = sqrt(area_rectangular);
        %     rectangle('Position',[-edge/2,-edge/2,edge,edge]);
        %%
        % 2.6 Generate other circles
        
        distance = zeros(1,num);    % distance between the new generated circle and all the other exsting circles
        r_sum2 = zeros(1,num);    % sum of the radius of the new generated circle and all the other exsting circles
        compare = ones(1,num);   % compare distance >= r_sum2
        c_round = zeros(2,3);     % c_round is to store the information of the two circles that is transfered to function third_circle
        %%
        % 2.7 After one "while loop", a porous medium will be generated*
        
        change_r = 0;
        change_circle = 0;
        
        while idx <= num      % one loop ends when all the radius have been used
            
            if flag == 1
                break;
            end
            
            b = boundary(c(:,1:2));     % return index of the outmost circles
            round_number = size(b,1)-1;    % the unmber of circles on each round; 3 circles in the 2nd round
            i = 1;
            idx_round = 0;
            %%
            % 2.7.1 To generate round by round. one "for loop" generates one round.*
            
            
            if change_round > 1
                trytry = trytry+1;
                break;
            end
            
            while i <= round_number
                
                overlap = 0;
                
                if change_circle > round_number - idx_round
                    change_round = change_round+1;
                    change_circle = 0;
                    break;
                end
                
                if change_r > num-idx+1
                    if i < round_number
                        change_circle = change_circle + 1;
                        i = i+1;
                        change_r = 0;
                    else
                        change_round = change_round+1;
                        change_circle = 0;
                        break;
                    end
                end
                %%
                % 2.7.1.3 this is to calculate the 3rd circles
                
                if i == round_number
                    c_round(1,:) = [c(b(round_number),1),c(b(round_number),2),c(b(round_number),3)];
                    c_round(2,:) = [c(b(1),1),c(b(1),2),c(b(1),3)];
                else
                    c_round(1,:) = [c(b(i),1),c(b(i),2),c(b(i),3)];
                    c_round(2,:) = [c(b(i+1),1),c(b(i+1),2),c(b(i+1),3)];
                end
                
                rr = r(idx);
                
                [x_3rd, y_3rd, x_3rd_opp, y_3rd_opp] = third_circle(c_round,rr,ecs);
                
                if x_3rd == 0 && y_3rd == 0
                    i = i+1;
                    continue;
                end
                %%
                % 2.7.1.4 This is to check _overlap_
                
                % overlap among circles
                distance(1:idx-1) = sqrt((x_3rd-c(1:idx-1,1)).^2+(y_3rd-c(1:idx-1,2)).^2);
                r_sum2(1:idx-1) = rr+c(1:idx-1,3)+ecs-0.001;
                compare(1:idx-1) = distance(1:idx-1) >= r_sum2(1:idx-1);
                
                if find(compare == 0) >= 1
                    overlap = 1;
                end
                
                % overlap between this circle and retangular boundaries
                %             if (x_3rd-rr < -edge/2 || y_3rd-rr < -edge/2 || x_3rd+rr > edge/2 || y_3rd+rr > edge/2 || overlap == 1)
                if (x_3rd-rr-ecs/2 < -edge/2 || y_3rd-rr-ecs/2 < -edge/2 || x_3rd+rr+ecs/2 > edge/2 || y_3rd+rr+ecs/2 > edge/2 || overlap == 1)
                    r(idx:fix(sort_fraction*num)-1) = r(idx+1:fix(sort_fraction*num));
                    r(fix(sort_fraction*num)) = rr;
                    change_r = change_r + 1;
                    continue;                     % jump out of for loop at line 101
                end
                %%
                % 2.7.1.5 If there are no overlaps, assign data to the 3rd circle. Draw this
                % circle and begin to time for the next circle. An itration time is the time to
                % generate a new circle
                
                c(idx,:) = [x_3rd, y_3rd, r(idx)];
                %             viscircles([c(idx,1) c(idx,2)],c(idx,3));
                %             NO = num2str(idx);
                %             text(c(idx,1),c(idx,2),NO);
                i = i+1;
                volume_fraction = sum(pi*c(:,3).^2)/area_rectangular;
                %%
                % 2.7.1.6 if all the radius have been used, end a loop
                
                if idx == num
                    idx = idx+1;
                    number = idx;
                    flag = 1;
                    break;
                end
                
                idx = idx+1;
                idx_round = idx_round+1;
                change_r = 0;
                change_circle = 0;
                change_round = 0;
                
            end
            
        end
        %%
        % 2.8 after a "while loop", check the volume fracture of axons. If it is bigger
        % than previous one, assign it to VF and assign the coresponding circles information
        % to C-fix. So VF is the largest volume fraction and c_fix is the coresponding
        % information all the circles.
        
        VF1 = [VF1; volume_fraction];    % this is to store volume fraction of axons in each loop
        
        if volume_fraction > VF
            number = idx;
            edge_out = edge;
            VF = volume_fraction;
            c_fix = c;
            d_mean_real = 2*sum(c_fix(:,3))./(idx-1);
            d_var = std2(c_fix(:,3));
        end
        
        if number == num-3 && trytry > 20 && trytry < trytime
            break;
        end
        
        if number == num-4 && trytry > 40 && trytry < trytime
            break;
        end
        
        if trytry > trytime
            volume_fraction_ini = 1-poro;   % volume_fraction is to get the area of rectangular
            volume_fraction = 0;  %  live ECM fraction
            VF = 0.1;
            idx = 1;    % idx for the circles that have been generated
            flag = 0;
            flag2 = 0;
            c_fix = zeros(num,3);   % to store all the circles' information of each picture
            Axon_fraction = zeros(1,1);    % to store all the Axon's fraction of each picture
            VF1 = [];    % to store volume fractions of every loop
            trytry = 0;
            number = 0;
            continue;
        end
        
        d_real = 2*nonzeros(c_fix(:,3));
        mu_real = log(median(d_real));
        delta_real = sqrt(mu_real-log(mode(d_real)));

    
end


end

